# Silent Whistle Chrome Extension

Chrome Extension that helps workers auto-fill the Massachusetts Attorney General's official wage complaint form.

## 🎯 Features

- **Auto-Fill**: One-click form filling with pre-saved data
- **Sidebar Guide**: Visual assistant panel on the form page
- **Safe & Legal**: User must review and submit themselves (no auto-submission)
- **Privacy**: All data stored locally in Chrome storage

## 📋 Installation (Developer Mode)

1. Open Chrome and navigate to `chrome://extensions`
2. Enable "Developer mode" (toggle in top right)
3. Click "Load unpacked"
4. Select the `extension` folder from this project
5. The extension icon should appear in your toolbar

## 🔧 Setup

### 1. Form Field Selectors (Auto-Detection)

**GOOD NEWS**: The extension now uses **multiple selector strategies** to automatically find fields, even if the form structure changes:

1. **Multiple CSS Selectors**: Each field has multiple selector patterns (id, name, class combinations)
2. **Label-Based Search**: If selectors fail, the extension searches by label text
3. **Dynamic Detection**: Automatically adapts to form structure changes

**If fields still don't fill**, you can add more selectors:

1. Open the official form: https://massago.hylandcloud.com/203appnet/UnityForm.aspx?key=UFKey
2. Open Chrome DevTools (F12)
3. Inspect the field that's not filling
4. Find the actual `id`, `name`, or `class` attribute
5. Add it to the `selectors` array in `lib/field-mappings.js` for that field

### 2. Connect to Main App

The extension reads data from Chrome storage. Your main Silent Whistle app should save data using:

```typescript
import { saveDataForExtension, convertToExtensionData } from '@/lib/extensionStorage';

// On the review/complete page, after user confirms their data:
const extensionData = convertToExtensionData(extractedData);
await saveDataForExtension(extensionData);
```

## 🚀 Usage

1. **Prepare Data**: Use the main Silent Whistle app to enter your complaint information
2. **Open Form**: Click the extension icon → "Open Official Form"
3. **Auto-Fill**: Click "⚡ Auto-Fill All Fields" in the sidebar
4. **Review**: Check all filled information
5. **Sign**: Check certification box and type your name (required by law)
6. **Submit**: Click the official Submit button yourself

## ⚠️ Legal Requirements

- **NO Auto-Submission**: The extension NEVER submits the form automatically
- **NO Auto-Signature**: Users must sign themselves (legal requirement)
- **User Control**: All actions are user-initiated (CFAA compliant)

## 🐛 Troubleshooting

### Fields Not Filling

The extension uses multiple strategies, but if fields still don't fill:

1. **Check Console**: Open DevTools (F12) → Console tab
   - Look for "Silent Whistle" messages
   - Check for "Failed to fill" warnings

2. **Inspect the Field**: 
   - Right-click the field → Inspect
   - Note the `id`, `name`, or `class` attribute
   - Check if there's a nearby `<label>` element

3. **Add Selector**:
   - Open `lib/field-mappings.js`
   - Find the field in `FIELD_MAP`
   - Add the new selector to the `selectors` array
   - Example:
     ```javascript
     employerName: {
       selectors: [
         '#txt_employer_name',
         'input[name="actualFieldName"]', // Add your new selector here
         // ... existing selectors
       ],
       // ...
     }
     ```

4. **Test Again**: Reload the extension and try auto-fill again

### Sidebar Not Appearing

- Ensure you're on the correct URL: `massago.hylandcloud.com`
- Check if extension is enabled in `chrome://extensions`
- Reload the page after installing the extension

### Data Not Loading

- Ensure the main app has saved data to Chrome storage
- Check Chrome storage: DevTools → Application → Storage → Local Storage
- Look for `silentWhistleData` key

## 📁 File Structure

```
extension/
├── manifest.json           # Extension configuration
├── content.js              # Injected into form page
├── styles.css              # Sidebar styling
├── popup.html              # Extension popup UI
├── popup.js                # Popup logic
├── background.js           # Service worker
├── lib/
│   └── field-mappings.js   # Form field selectors
└── icons/                  # Extension icons (add your own)
```

## 🔒 Privacy

- All data is stored locally in Chrome storage
- No data is sent to any server
- Extension only works on the official MA AGO form page

## 📝 Notes

- Form structure may change - keep `field-mappings.js` updated
- Test thoroughly before production use
- Always verify filled data before submission

