// background.js - Service worker for Chrome Extension

chrome.runtime.onInstalled.addListener(() => {
  console.log('Silent Whistle extension installed');
});

// Listen for messages from content script or popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'getData') {
    chrome.storage.local.get(['silentWhistleData'], (result) => {
      sendResponse({ data: result.silentWhistleData });
    });
    return true; // Keep channel open for async response
  }
  
  if (request.action === 'saveData') {
    chrome.storage.local.set({ silentWhistleData: request.data }, () => {
      sendResponse({ success: true });
    });
    return true;
  }
});


